package org.msh.tb.cases.adsm;

import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.faces.FacesMessages;
import org.msh.etbm.commons.transactionlog.mapping.LogInfo;
import org.msh.tb.cases.CaseHome;
import org.msh.tb.entities.CaseSideEffect;
import org.msh.tb.entities.enums.CaseSideEffectType;

@Name("adverseEventHome")
@LogInfo(roleName="ADV_EFFECTS", entityClass=CaseSideEffect.class)
public class AdverseEventHome extends SideEffectHome {

    @In
    CaseHome caseHome;
    @In(create=true)
    FacesMessages facesMessages;

    @Factory("adverseEvent")
    public CaseSideEffect getCaseSideEffect() {
        return getInstance();
    }

    @Override
    public CaseSideEffectType getType() {
        return CaseSideEffectType.ADVERSE_EVENT_OF_SPECIAL_INTEREST;
    }

    @Override
    protected CaseHome caseHome() {
        return caseHome;
    }

    @Override
    protected FacesMessages facesMessages() {
        return facesMessages;
    }

    @Override
    public Class<CaseSideEffect> getEntityClass() {
        return CaseSideEffect.class;
    }
}
